<?php
/**
 *  @package AdminTools
 *  @copyright Copyright (c)2010-2011 Nicholas K. Dionysopoulos
 *  @license GNU General Public License version 3, or later
 *  @version $Id: cleantmp.php 124 2010-12-31 11:22:51Z nikosdion $
 */

// Protect from unauthorized access
defined('_JEXEC') or die('Restricted Access');

jimport('joomla.application.component.model');
jimport('joomla.client.ftp');

class AdmintoolsModelCleantmp extends JModel
{

	/** @var float The time the process started */
	private $startTime = null;

	/** @var array The folders to process */
	private $folderStack = array();

	/** @var array The files to process */
	private $filesStack = array();

	/** @var int Total numbers of folders in this site */
	public $totalFolders = 0;

	/** @var int Numbers of folders already processed */
	public $doneFolders = 0;

	/**
	 * Returns the current timestampt in decimal seconds
	 */
	private function microtime_float()
	{
		list($usec, $sec) = explode(" ", microtime());
		return ((float)$usec + (float)$sec);
	}

	/**
	 * Starts or resets the internal timer
	 */
	private function resetTimer()
	{
		$this->startTime = $this->microtime_float();
	}

	/**
	 * Makes sure that no more than 3 seconds since the start of the timer have
	 * elapsed
	 * @return bool
	 */
	private function haveEnoughTime()
	{
		$now = $this->microtime_float();
		$elapsed = abs($now - $this->startTime);
		return $elapsed < 2;
	}

	/**
	 * Saves the file/folder stack in the session
	 */
	private function saveStack()
	{
		$stack = array(
			'folders'	=> $this->folderStack,
			'files'		=> $this->filesStack,
			'total'		=> $this->totalFolders,
			'done'		=> $this->doneFolders
		);
		$stack = json_encode($stack);
		if(function_exists('base64_encode') && function_exists('base64_decode'))
		{
			if(function_exists('gzdeflate') && function_exists('gzinflate'))
			{
				$stack = gzdeflate($stack, 9);
			}
			$stack = base64_encode ($stack);
		}
		$session =& JFactory::getSession();
		$session->set('cleantmp_stack', $stack ,'admintools');
	}

	/**
	 * Resets the file/folder stack saved in the session
	 */
	private function resetStack()
	{
		$session =& JFactory::getSession();
		$session->set('cleantmp_stack', '' ,'admintools');
		$this->folderStack = array();
		$this->filesStack = array();
		$this->totalFolders = 0;
		$this->doneFolders = 0;
	}

	/**
	 * Loads the file/folder stack from the session
	 */
	private function loadStack()
	{
		$session =& JFactory::getSession();
		$stack = $session->get('cleantmp_stack', '' ,'admintools');

		if(empty($stack))
		{
			$this->folderStack = array();
			$this->filesStack = array();
			$this->totalFolders = 0;
			$this->doneFolders = 0;
			return;
		}

		if(function_exists('base64_encode') && function_exists('base64_decode'))
		{
			$stack = base64_decode($stack);
			if(function_exists('gzdeflate') && function_exists('gzinflate'))
			{
				$stack = gzinflate($stack);
			}
		}
		$stack = json_decode($stack, true);

		$this->folderStack = $stack['folders'];
		$this->filesStack = $stack['files'];
		$this->totalFolders = $stack['total'];
		$this->doneFolders = $stack['done'];
	}

	/**
	 * Scans $root for directories and updates $folderStack
	 * @param string $root The full path of the directory to scan
	 */
	public function getDirectories($root = null)
	{
		$jreg =& JFactory::getConfig();
		$tmpdir = $jreg->getValue('config.tmp_path');

		if(empty($root)) $root = $tmpdir;
		jimport('joomla.filesystem.folder');

		$folders = JFolder::folders($root,'.',false,true);
		$this->totalFolders += count($folders);

		foreach($folders as $folder)
		{
			$this->getDirectories($folder);
			$this->getFiles($folder);
		}
		$this->folderStack = array_merge($this->folderStack, $folders);
	}

	/**
	 * Scans $root for files and updates $filesStack
	 * @param string $root The full path of the directory to scan
	 */
	public function getFiles($root = null)
	{
		$jreg =& JFactory::getConfig();
		$tmpdir = $jreg->getValue('config.tmp_path');

		if(empty($root)) $root = $tmpdir;

		if(empty($root))
		{
			return;
		}

		$root = rtrim($root,'/');
		$tmpdir = rtrim($tmpdir,'/');

		jimport('joomla.filesystem.folder');

		$folders = JFolder::files($root,'.',false,true);

		if($root == $tmpdir) {
			foreach($folders as $folder)
			{
				if(basename($folder) == 'index.html') continue;
				if(basename($folder) == '.htaccess') continue;
				$this->filesStack[] = $folder;
			}
		} else {
			$this->filesStack = array_merge($this->filesStack, $folders);
		}

		$this->totalFolders += count($folders);
	}

	public function startScanning()
	{
		$this->resetStack();
		$this->resetTimer();
		$this->getDirectories();
		$this->getFiles();
		asort($this->folderStack);
		asort($this->filesStack);

		$this->saveStack();

		if(!$this->haveEnoughTime())
		{
			return true;
		}
		else
		{
			return $this->run(false);
		}
	}

	private function delete($path)
	{
		// Initialize variables
		jimport('joomla.client.helper');
		$ftpOptions = JClientHelper::getCredentials('ftp');

		// Check to make sure the path valid and clean
		$n_path = @realpath($path);
		$path = empty($n_path) ? $path : $n_path;

		if ($ftpOptions['enabled'] == 1) {
			// Connect the FTP client
			$ftp = &JFTP::getInstance(
				$ftpOptions['host'], $ftpOptions['port'], null,
				$ftpOptions['user'], $ftpOptions['pass']
			);
		}

		if(@unlink($path)) {
			$ret = true;
		} elseif(@rmdir($path)) {
			$ret = true;
		} elseif ($ftpOptions['enabled'] == 1) {
			if(substr($path,0,strlen(JPATH_ROOT)) !== JPATH_ROOT) return false;
			// Translate path and delete
			$path = JPath::clean(str_replace(JPATH_ROOT, $ftpOptions['root'], $path), '/');
			// FTP connector throws an error
			$ret = $ftp->delete($path);
		} else {
			return false;
		}
		return $ret;
	}

	public function run($resetTimer = true)
	{
		if($resetTimer) $this->resetTimer();

		$this->loadStack();

		$result = true;
		while($result && $this->haveEnoughTime())
		{
			$result = $this->RealRun();
		}

		$this->saveStack();

		return $result;
	}

	private function RealRun()
	{
		if(!empty($this->filesStack))
		{
			while(!empty($this->filesStack) && $this->haveEnoughTime())
			{
				$file = array_pop($this->filesStack);
				$this->doneFolders++;
				$this->delete($file);
			}
		}

		if(empty($this->filesStack) && !empty($this->folderStack))
		{
			while(!empty($this->folderStack) && $this->haveEnoughTime())
			{
				$folder = array_pop($this->folderStack);
				$this->doneFolders++;
				$this->delete($folder);
			}
		}

		if(empty($this->filesStack) && empty($this->folderStack))
		{
			// Just finished
			$this->resetStack();
			return false;
		}

		// If we have more folders or files, continue in the next step
		return true;
	}

}
