<?php
/**
 * @version	    1.0
 * @package		JPlugin
 * @subpackage	System
 * @copyright	Scouting Nederland 2011, All rights reserved
 * @license		GNU/GPL, see LICENSE.php
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

/**
 * Plugin that redirects a user to a custom login page
 *
 * @author      Frits Zwegers
 * @package		JPlugin
 * @subpackage	System
 */
class plgSystemRedirectLogin extends JPlugin {

    /**
     * @param object $subject The object to observe
     * @param array $config  An array that holds the plugin configuration
     */
    public function plgSystemRedirectLogin(&$subject, $config) {
        parent::__construct($subject, $config);
    }


    public function onAfterInitialise() {
        $application = JFactory::getApplication();
        if ($application->isAdmin()) {
            return; //Skip admin site redirect
        }
        $URI = JFactory::getURI();
        $params = $URI->getQuery(true);
        if (array_key_exists('option', $params) && $params['option'] == 'com_user' &&
            array_key_exists('view', $params) && $params['view'] == 'login') {
            //login page called => redirect
            $params['option'] = 'com_content';
            $params['view'] = 'article';
            $params['id'] = $this->params->get('redirect_id');
            $URI->setQuery($params); //Overwrite the (stored) JURI with new query params.
            JRequest::setVar('option', 'com_content');
            JRequest::setVar('view', 'article');
            JRequest::setVar('id', $this->params->get('redirect_id'));
        }

    }
}
